//Lab 08:  Computation of PID Controller gains based on IMC Design for the First order Delay system.

//scilab - 6.0.0
// Operating System : Windows 10, 64-bit

//------------------------------------------------------------------
close;
clc;
clear;
//------------------------------------------------------------------

//System transfer function
kp=0.5;
tp=1.5;
theta=0.8; //for Pade approximation of the delay of 0.8sec
s=poly(0,'s');
num=kp;
den=tp*s+1;

//IMC filter designed parameters
lambda=0.5;

//PID gain computation
kc=(tp+0.5*theta)/kp/(lambda+0.5*theta);
ti=tp+0.5*theta;
td=tp*theta/(2*tp+theta);

// Response of the system with IMC based PID control
figure;
importXcosDiagram(".\Lab08_IMC_PID_Model.xcos")
xcos_simulate(scs_m,4);
scs_m.props.context
plot(yt.time,yt.values,'thickness',2)
xlabel('t (sec.)','fontsize',2);
ylabel('y(t)','fontsize',2);
title("Response of the system with IMC based PID control.",'fontsize',4);
set(gca(),"grid",[1 1])
xset('font size',2)

exec .\\figure_properties.sci; //custom script for setting figure properties
